#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
typedef long double ld;

vector <int> graf[300005];
int interval[600005];
int lastr[600005];
int lastl[600005];
int dist[3005];
int par[300005][20];
int son[300005][20];

const int INF = 1000000000;

int l[300005];
int r[300005];

void bfs(int root, int n){
    for(int i=1; i<=n; i++){
        dist[i] = INF;
    }
    queue <int> q;
    q.push(root);
    dist[root] = 0;
    while(!q.empty()){
        int v = q.front();
        q.pop();
        for(auto c : graf[v]){
            if(dist[c] > dist[v]+1){
                dist[c] = dist[v]+1;
                q.push(c);
            }
        }
    }
}

bool parent(int a, int b){
    return l[a] <= l[b] && r[b] <= r[a];
}

int main(){
    ios_base::sync_with_stdio(false), cin.tie(0);
    cout.precision(10);
    cout << fixed;

    int n, q;
    cin >> n >> q;
    if(1LL*n*q > 1e8) return 0;
    for(int i=1; i<=2*n; i++){
        cin >> interval[i];
        lastl[i] = lastl[i-1];
        if(l[interval[i]]){
            r[interval[i]] = i;
            lastl[i] = max(lastl[i], l[interval[i]]);
        }
        else{
            l[interval[i]] = i;
        }
    }
    for(int i=1; i<=2*n; i++){
        lastr[i] = lastr[i-1];
        if(l[interval[i]] == i){
            lastr[i] = max(lastr[i], r[interval[i]]);
        }
    }
    for(int i=1; i<=n; i++){
        for(int j=1; j<=n; j++){
            if(i == j) continue;
            if(l[i] <= l[j] && r[j] <= r[i]){
                graf[i].push_back(j);
                graf[j].push_back(i);
            }
        }
    }
    for(int i=1; i<=n; i++){
        /// u koga ide i ako ide u parenta?
        /// najdesnje r od 1 do l[i]-1
        if(lastr[l[i]-1] > r[i]){
            par[i][0] = interval[lastr[l[i]-1]];
        }
        /// u koga ide ako ide u sina?
        /// najdesnje l od l[i] do r[i], tj. najdesnje l od 1 do r[i]
        if(lastl[r[i]] > l[i]){
            son[i][0] = interval[lastl[r[i]]];
        }
        //cout << i << " " << par[i][0] << " " << son[i][0] << endl;
    }
    for(int i=1; i<=n; i++){
        par[i][1] = son[par[i][0]][0];
        son[i][1] = par[son[i][0]][0];
    }
    for(int j=2; j<=19; j++){
        for(int i=1; i<=n; i++){
            par[i][j] = par[par[i][j-1]][j-1];
            son[i][j] = son[son[i][j-1]][j-1];
            //if(par[i][j]) cout << i << " " << j << " " << par[i][j] << endl;
        }
    }
    while(q--){
        int a, b;
        cin >> a >> b;
        if(l[a] <= l[b] && r[b] <= r[a]){
            cout << "1\n";
            continue;
        }
        if(l[b] <= l[a] && r[a] <= r[b]){
            cout << "1\n";
            continue;
        }
        if(l[a] > l[b]) swap(a, b);
        int cnt = 0;
        int res = n+5;
        /// prvo u parenta
        int x = a;
        while(1){
            cnt++;
            x = par[x][0];
            if(parent(x, b) || parent(b, x)){
                res = min(res, cnt+1);
                break;
            }
            cnt++;
            x = son[x][0];
            if(parent(b, x) || parent(x, b)){
                res = min(res, cnt+1);
                break;
            }
            if(cnt > res) break;
        }
        ///prvo u sina
        x = a;
        while(1){
            cnt++;
            x = son[x][0];
            if(parent(b, x) || parent(x, b)){
                res = min(res, cnt+1);
                break;
            }
            cnt++;
            x = par[x][0];
            if(parent(x, b) || parent(b, x)){
                res = min(res, cnt+1);
                break;
            }
            if(cnt > res) break;
        }
        if(res == n+5){
            cout << "-1\n";
        }
        else cout << res << "\n";
    }
    return 0;
}